/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.init;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import xreliquary.Reliquary;
import xreliquary.blocks.BlockAlkahestryAltar;
import xreliquary.blocks.BlockApothecaryCauldron;
import xreliquary.blocks.BlockApothecaryMortar;
import xreliquary.blocks.BlockBase;
import xreliquary.blocks.BlockFertileLilypad;
import xreliquary.blocks.BlockInterdictionTorch;
import xreliquary.blocks.BlockPedestal;
import xreliquary.blocks.BlockPedestalPassive;
import xreliquary.blocks.BlockWraithNode;
import xreliquary.blocks.tile.TileEntityAltar;
import xreliquary.blocks.tile.TileEntityCauldron;
import xreliquary.blocks.tile.TileEntityMortar;
import xreliquary.blocks.tile.TileEntityPedestal;
import xreliquary.blocks.tile.TileEntityPedestalPassive;
import xreliquary.items.block.ItemBlockBase;
import xreliquary.items.block.ItemBlockPedestal;
import xreliquary.items.block.ItemFertileLilyPad;
import xreliquary.reference.Settings;

@Mod.EventBusSubscriber(modid="xreliquary")
public class ModBlocks {
    public static BlockApothecaryCauldron apothecaryCauldron;
    public static BlockAlkahestryAltar alkahestryAltar;
    public static BlockBase apothecaryMortar;
    public static BlockFertileLilypad fertileLilypad;
    public static BlockInterdictionTorch interdictionTorch;
    public static BlockWraithNode wraithNode;
    public static BlockPedestal pedestal;
    public static BlockPedestalPassive pedestalPassive;
    public static int snowStateId;

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        alkahestryAltar = ModBlocks.registerBlock((IForgeRegistry<Block>)registry, new BlockAlkahestryAltar(), "altar", TileEntityAltar.class);
        if (!Settings.Disable.disablePotions) {
            apothecaryCauldron = ModBlocks.registerBlock((IForgeRegistry<Block>)registry, new BlockApothecaryCauldron(), "apothecary_cauldron", TileEntityCauldron.class);
            apothecaryMortar = ModBlocks.registerBlock((IForgeRegistry<Block>)registry, new BlockApothecaryMortar(), "apothecary_mortar", TileEntityMortar.class);
        }
        fertileLilypad = ModBlocks.registerBlock((IForgeRegistry<Block>)registry, new BlockFertileLilypad(), "fertile_lilypad");
        interdictionTorch = ModBlocks.registerBlock((IForgeRegistry<Block>)registry, new BlockInterdictionTorch(), "interdiction_torch");
        wraithNode = ModBlocks.registerBlock((IForgeRegistry<Block>)registry, new BlockWraithNode(), "wraith_node");
        if (!Settings.Disable.disablePedestal) {
            pedestal = ModBlocks.registerBlock((IForgeRegistry<Block>)registry, new BlockPedestal(), "pedestal", TileEntityPedestal.class);
        }
        if (!Settings.Disable.disablePedestal) {
            pedestalPassive = ModBlocks.registerBlock((IForgeRegistry<Block>)registry, new BlockPedestalPassive(), "pedestal_passive", TileEntityPedestalPassive.class);
        }
    }

    @SubscribeEvent
    public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        ModBlocks.registerItemBlock((IForgeRegistry<Item>)registry, alkahestryAltar, "altar");
        if (!Settings.Disable.disablePotions) {
            ModBlocks.registerItemBlock((IForgeRegistry<Item>)registry, apothecaryCauldron, "apothecary_cauldron");
            ModBlocks.registerItemBlock((IForgeRegistry<Item>)registry, apothecaryMortar, "apothecary_mortar");
        }
        ModBlocks.registerItemBlock((IForgeRegistry<Item>)registry, (Block)fertileLilypad, new ItemFertileLilyPad(), "fertile_lilypad", false);
        ModBlocks.registerItemBlock((IForgeRegistry<Item>)registry, (Block)interdictionTorch, "interdiction_torch");
        ModBlocks.registerItemBlock((IForgeRegistry<Item>)registry, wraithNode, "wraith_node");
        if (!Settings.Disable.disablePedestal) {
            ModBlocks.registerItemBlock((IForgeRegistry<Item>)registry, pedestal, new ItemBlockPedestal(pedestal), "pedestal", true);
        }
        if (!Settings.Disable.disablePedestalPassive) {
            ModBlocks.registerItemBlock((IForgeRegistry<Item>)registry, pedestalPassive, new ItemBlockPedestal(pedestalPassive), "pedestal_passive", true);
        }
    }

    private static <T extends Block> T registerBlock(IForgeRegistry<Block> registry, T block, String name) {
        return ModBlocks.registerBlock(registry, block, name, null);
    }

    private static <T extends Block> T registerBlock(IForgeRegistry<Block> registry, T block, String name, Class<? extends TileEntity> tileClass) {
        registry.register(block);
        if (tileClass != null) {
            GameRegistry.registerTileEntity(tileClass, (String)("xreliquary:tile_" + name));
        }
        return block;
    }

    private static void registerItemBlock(IForgeRegistry<Item> registry, Block block, String name) {
        ModBlocks.registerItemBlock(registry, block, new ItemBlockBase(block), name, false);
    }

    private static void registerItemBlock(IForgeRegistry<Item> registry, Block block, ItemBlockBase itemBlock, String name, boolean jeiOneDescription) {
        registry.register(itemBlock.setRegistryName(block.getRegistryName()));
        Reliquary.PROXY.registerJEI(block, name, jeiOneDescription);
    }

    public static void initSnowStateId() {
        snowStateId = Block.func_176210_f((IBlockState)Blocks.field_150433_aE.func_176223_P());
    }

    static {
        snowStateId = 0;
    }
}

